import * as request from 'superagent';
export interface SearchOptions {
    version?: string;
    key?: string;
    retry?: number;
    timeout?: number | {
        deadline: number;
        response: number;
    };
    clientRequestId?: string;
    returnClientRequestId?: boolean;
    ifMatch?: string;
    ifNoneMatch?: string;
}
export interface SearchRequest<T> {
    method: string;
    path: string;
    headers?: {
        [key: string]: string;
    };
    query?: {
        [key: string]: string;
    };
    body?: any;
    parser?: Parser;
}
export interface AzureSearchResponse<T> {
    result: T;
    properties: AzureSearchResponseProperties;
    statusCode: number;
    timer: SearchTimer;
}
export interface AzureSearchResponseProperties {
    requestId: string;
    elapsedTime: number;
    clientRequestId?: string;
    eTag?: string;
    location?: string;
}
export interface SearchTimer {
    start: Date;
    response: [number, number];
    end: [number, number];
}
export interface ListResults<T> {
    value: T[];
}
export interface ListOptions {
    $select?: string[];
}
export declare type SearchCallback<T> = (err: Error, resp: AzureSearchResponse<T>) => void;
export declare type OptionsOrCallback<T> = SearchOptions | SearchCallback<T>;
export declare type ErrorCallback = (err: Error) => void;
export declare type ResponseCallback = (resp: any) => void;
export declare type RequestCallback = (req: any) => void;
export declare type ParserCallback = (err: Error, body: any) => void;
export declare type Parser = (res: request.Response, callback: ParserCallback) => void;
