/// <reference types="node" />
import { Document, IndexDocument, IndexingResult } from 'azure-search-types';
export declare type FlushCallback = (data: Buffer) => Promise<IndexingResult[]>;
export declare class IndexBuffer<TDocument = Document> {
    private flushHandler;
    private readonly chunks;
    private bytes;
    private count;
    constructor(flushHandler: FlushCallback);
    add(document: IndexDocument & TDocument): Promise<void | IndexingResult[]>;
    flush(): Promise<IndexingResult[]>;
    private chunk;
    private reset;
}
