"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const apg_lib_1 = require("apg-lib");
const util_1 = require("./util");
function attributeGroup(state, chars, phraseIndex, phraseLength, yard) {
    switch (state) {
        case apg_lib_1.ids.SEM_PRE:
            yard.pre("attributeGroup");
            break;
        case apg_lib_1.ids.SEM_POST:
            const { attributePath, filter } = yard.post("attributeGroup");
            if (attributePath.length !== 1) {
                throw new Error(`INVARIANT: Expected 1 attributePath, but got ${attributePath.length};`);
            }
            if (filter.length !== 1) {
                throw new Error(`INVARIANT: Expected 1 filter, but got ${filter.length};`);
            }
            yard.tracks.attributeGroup.push((data) => util_1.traverse(attributePath[0], data).some(x => filter[0](x)));
            break;
    }
    return apg_lib_1.ids.SEM_OK;
}
exports.attributeGroup = attributeGroup;
//# sourceMappingURL=attributeGroup.js.map