"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const apg_lib_1 = require("apg-lib");
const util_1 = require("./util");
// TODO: implement unicode string comparisons using
// String.prototype.localeCompare()
function eq(path, value, data) {
    return util_1.traverse(path, data).some((x) => {
        const v = typeof x === typeof value
            ? x
            : typeof x === "object" &&
                x &&
                Object.prototype.propertyIsEnumerable.call(x, "value") &&
                typeof x.value == typeof value
                ? x.value
                : undefined;
        return typeof v === "string" && typeof value === "string"
            ? value.localeCompare(v, undefined, { sensitivity: "base" }) === 0
            : v === value;
    });
}
function ne(path, value, data) {
    return util_1.traverse(path, data).some((x) => {
        const v = typeof x === typeof value
            ? x
            : typeof x === "object" &&
                x &&
                Object.prototype.propertyIsEnumerable.call(x, "value") &&
                typeof x.value == typeof value
                ? x.value
                : undefined;
        return typeof v === "string" && typeof value === "string"
            ? value.localeCompare(v, undefined, { sensitivity: "base" }) !== 0
            : v !== value;
    });
}
function co(path, value, data) {
    return util_1.traverse(path, data).some((x) => {
        const v = typeof x === typeof value
            ? x
            : typeof x === "object" &&
                x &&
                Object.prototype.propertyIsEnumerable.call(x, "value") &&
                typeof x.value == typeof value
                ? x.value
                : undefined;
        return typeof v === "string" && v.includes(value);
    });
}
function sw(path, value, data) {
    return util_1.traverse(path, data).some((x) => {
        const v = typeof x === typeof value
            ? x
            : typeof x === "object" &&
                x &&
                Object.prototype.propertyIsEnumerable.call(x, "value") &&
                typeof x.value == typeof value
                ? x.value
                : undefined;
        return typeof v === "string" && v.substring(0, value.length) === value;
    });
}
function ew(path, value, data) {
    return util_1.traverse(path, data).some((x) => {
        const v = typeof x === typeof value
            ? x
            : typeof x === "object" &&
                x &&
                Object.prototype.propertyIsEnumerable.call(x, "value") &&
                typeof x.value == typeof value
                ? x.value
                : undefined;
        return (typeof v === "string" &&
            v.length >= value.length &&
            v.substring(v.length - value.length) === value);
    });
}
function gt(path, value, data) {
    return util_1.traverse(path, data).some((x) => {
        const v = typeof x === typeof value
            ? x
            : typeof x === "object" &&
                x &&
                Object.prototype.propertyIsEnumerable.call(x, "value") &&
                typeof x.value == typeof value
                ? x.value
                : undefined;
        return v > value;
    });
}
function ge(path, value, data) {
    return util_1.traverse(path, data).some((x) => {
        const v = typeof x === typeof value
            ? x
            : typeof x === "object" &&
                x &&
                Object.prototype.propertyIsEnumerable.call(x, "value") &&
                typeof x.value == typeof value
                ? x.value
                : undefined;
        return v >= value;
    });
}
function lt(path, value, data) {
    return util_1.traverse(path, data).some((x) => {
        const v = typeof x === typeof value
            ? x
            : typeof x === "object" &&
                x &&
                Object.prototype.propertyIsEnumerable.call(x, "value") &&
                typeof x.value == typeof value
                ? x.value
                : undefined;
        return v < value;
    });
}
function le(path, value, data) {
    return util_1.traverse(path, data).some((x) => {
        {
            const v = typeof x === typeof value
                ? x
                : typeof x === "object" &&
                    x &&
                    Object.prototype.propertyIsEnumerable.call(x, "value") &&
                    typeof x.value == typeof value
                    ? x.value
                    : undefined;
            return v <= value;
        }
    });
}
const map = {
    eq,
    ne,
    co,
    sw,
    ew,
    gt,
    ge,
    lt,
    le
};
function infixAssertionOperator(state, chars, phraseIndex, phraseLength, yard) {
    switch (state) {
        case apg_lib_1.ids.SEM_PRE:
            break;
        case apg_lib_1.ids.SEM_POST:
            const op = apg_lib_1.utils
                .charsToString(chars, phraseIndex, phraseLength)
                .toLowerCase();
            const fn = map[op];
            if (!fn) {
                throw new Error(`INVARIANT: No such infix assertion operator \`${op}\`.`);
            }
            yard.tracks.infixAssertionOperator.push(fn);
            break;
    }
    return apg_lib_1.ids.SEM_OK;
}
exports.infixAssertionOperator = infixAssertionOperator;
//# sourceMappingURL=infixAssertionOperator.js.map